/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import jclass.beans.GroupPanel;
import jclass.table3.JCCellRange;
import jclass.table3.JCTblRevConverter;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.bean.SpanRenderer;
import jclass.util.JCVector;

public class SpanningCellsEditor
extends SeriesEditor
implements ActionListener {
    private Button buttonSpan;
    private Button buttonUnspan;

    public SpanningCellsEditor() {
        super(1);
    }

    public void setValue(Object object) {
        this.tableView.setSpanningCells((Vector)object);
        super.setValue(object);
    }

    public Object getValue() {
        return this.tableView.getSpanningCells();
    }

    public String getAsText() {
        return this.getStringValue(this.nl);
    }

    public String getJavaInitializationString() {
        return "jclass.table3.JCTblConverter.toRangeList(\"" + this.getAsText() + "\")";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonSpan) || object.equals(this.buttonUnspan)) {
            this.updateSpan(object.equals(this.buttonSpan));
            JCCellRange jCCellRange = new JCCellRange();
            if (this.tableView.getSelectedRange(0, jCCellRange)) {
                this.updatePropertyPanel(jCCellRange);
            }
        }
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new SpanRenderer(this);
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.support.firePropertyChange("spanningCells", null, this.getValue());
        if (jCCellRange == null) {
            return;
        }
        this.buttonSpan.setEnabled(this.canSpan(jCCellRange));
        this.buttonUnspan.setEnabled(this.isSpanned(jCCellRange));
    }

    protected Component makePropertyPanel() {
        GroupPanel groupPanel = new GroupPanel("Spanning cells");
        groupPanel.setLayout(new FlowLayout());
        this.buttonSpan = new Button("Span");
        this.buttonUnspan = new Button("Unspan");
        this.buttonSpan.setEnabled(false);
        this.buttonUnspan.setEnabled(false);
        groupPanel.add(this.buttonSpan);
        groupPanel.add(this.buttonUnspan);
        this.buttonSpan.addActionListener(this);
        this.buttonUnspan.addActionListener(this);
        return groupPanel;
    }

    private String getStringValue(String string) {
        return JCTblRevConverter.fromRangeList((JCVector)this.getValue());
    }

    private void updateSpan(boolean bl) {
        JCCellRange jCCellRange = this.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        if (bl) {
            this.tableView.addSpan(jCCellRange);
            return;
        }
        this.removeSpan(jCCellRange);
    }

    private boolean canSpan(JCCellRange jCCellRange) {
        return !this.isSpanned(jCCellRange) && jCCellRange != null;
    }

    private boolean isSpanned(JCCellRange jCCellRange) {
        if (jCCellRange == null) {
            return false;
        }
        int n = jCCellRange.start_row;
        while (n <= jCCellRange.end_row) {
            int n2 = jCCellRange.start_column;
            while (n2 <= jCCellRange.end_column) {
                if (this.tableView.isSpanned(n, n2)) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    private void removeSpan(JCCellRange jCCellRange) {
        if (jCCellRange != null) {
            int n = jCCellRange.start_row;
            while (n <= jCCellRange.end_row) {
                int n2 = jCCellRange.start_column;
                while (n2 <= jCCellRange.end_column) {
                    this.tableView.removeSpan(n, n2);
                    ++n2;
                }
                ++n;
            }
        }
    }
}

